/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.peorb.client;

import com.filenet.apiimpl.util.UTF8Helper;
import filenet.pe.peorb.FileNet_PERPC.RPCHeader;
import filenet.pe.peorb.client.IdTypeFlagsHolder;
import filenet.vw.api.VWException;
import filenet.vw.base.StringUtils;
import filenet.vw.base.logging.Logger;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

class SyncVersion {
    static final String m_className = "SyncVersion";
    protected static Logger logger = Logger.getLogger("filenet.pe.peorb.signature");
    protected static final String myHeader = "name;nTimes;worstTime;whenWorstTime;bestTime;whenBestTime;avgTime;totalTime\n";
    public static final String DELIM = ";";
    private static _RPCID[] RPCID_TABLE = new _RPCID[]{new _RPCID("Qv", "orb_rpc_checkVWVersion"), new _RPCID("W2", "orb_rpc_convertSecurityIdstoNames"), new _RPCID("E3", "orb_rpc_convertSecurityNamestoIds"), new _RPCID("R4", "orb_rpc_createLiveWorkObject"), new _RPCID("T5", "orb_rpc_deleteInjectSession"), new _RPCID("Y6", "orb_rpc_deleteUserInfo"), new _RPCID("U7", "orb_rpc_deleteWorkObject"), new _RPCID("I8", "orb_rpc_fetchAttachmentIsReferenced"), new _RPCID("O9", "orb_rpc_fetchAttachmentIsReferencedBy"), new _RPCID("P0", "orb_rpc_fetchCount"), new _RPCID("X1", "orb_rpc_fetchQuery"), new _RPCID("A2", "orb_rpc_fetchServerConfiguration"), new _RPCID("S3", "orb_rpc_fetchUserEnvironmentRecords"), new _RPCID("D4", "orb_rpc_fetchUserInfo"), new _RPCID("F5", "orb_rpc_getAttributes"), new _RPCID("G6", "orb_rpc_getCallStatistics"), new _RPCID("H7", "orb_rpc_getCEMPuri"), new _RPCID("J8", "orb_rpc_getConfigInfo"), new _RPCID("K9", "orb_rpc_getCurrentVersion"), new _RPCID("L0", "orb_rpc_getExposedFields"), new _RPCID("ZA", "orb_rpc_getFileFromServer"), new _RPCID("XS", "orb_rpc_getIndexFields"), new _RPCID("CD", "orb_rpc_getLaunchStepProcessor"), new _RPCID("VF", "orb_rpc_getLimitApplicationFunctionalityFlag"), new _RPCID("BG", "orb_rpc_getLockStatus"), new _RPCID("NH", "orb_rpc_getLogDefinition"), new _RPCID("MJ", "orb_rpc_getLogNames"), new _RPCID("qK", "orb_rpc_getMultipleWorkflowSignatures"), new _RPCID("wL", "orb_rpc_getNewStepElement"), new _RPCID("eQ", "orb_rpc_getProcess"), new _RPCID("rW", "orb_rpc_getQueueDefinition"), new _RPCID("tE", "orb_rpc_getQueueDepth"), new _RPCID("yR", "orb_rpc_getQueueNames"), new _RPCID("uT", "orb_rpc_getQueueOperations"), new _RPCID("iY", "orb_rpc_getQueueStatistics"), new _RPCID("oU", "orb_rpc_getRosterCount"), new _RPCID("pI", "orb_rpc_getRosterDefinition"), new _RPCID("aO", "orb_rpc_getRosterNames"), new _RPCID("sP", "orb_rpc_getRosterStatistics"), new _RPCID("dZ", "orb_rpc_getStepProcessorById"), new _RPCID("fX", "orb_rpc_getStepProcessorByName"), new _RPCID("gC", "orb_rpc_getStepProcessorList"), new _RPCID("hV", "orb_rpc_getSystemConfigInfo"), new _RPCID("jB", "orb_rpc_getSystemWideConfig"), new _RPCID("kN", "orb_rpc_getWorkClassNames"), new _RPCID("lM", "orb_rpc_getWorkClassXML"), new _RPCID("z1", "orb_rpc_getWorkElementFields"), new _RPCID("x2", "orb_rpc_getWorkflowSignature"), new _RPCID("c3", "orb_rpc_initializeAllRegions"), new _RPCID("v4", "orb_rpc_initializeRegion"), new _RPCID("b5", "orb_rpc_logMessage"), new _RPCID("n6", "orb_rpc_ping"), new _RPCID("m7", "orb_rpc_recoverUser"), new _RPCID("Q8", "orb_rpc_removeDatabase"), new _RPCID("W9", "orb_rpc_RosterOrQueueGetReturnStackElements"), new _RPCID("E0", "orb_rpc_saveNewStepElement"), new _RPCID("RQ", "orb_rpc_saveUserInfo"), new _RPCID("TW", "orb_rpc_setSystemWideConfig"), new _RPCID("YE", "orb_rpc_shutdown"), new _RPCID("U1", "orb_rpc_transferConfig"), new _RPCID("I2", "orb_rpc_transferWorkflow"), new _RPCID("O3", "orb_rpc_transferWorkflowCollection"), new _RPCID("P4", "orb_rpc_unlockSaveAndRedirect"), new _RPCID("aM", "orb_rpc_RosterOrQueueGetWorkElementFields"), new _RPCID("5t", "orb_rpc_getAvailableLocales"), new _RPCID("b0", "orb_rpc_fetchRoleParticipants"), new _RPCID("Wc", "orb_rpc_fetchMyRole"), new _RPCID("iM", "orb_rpc_fetchMyRoles"), new _RPCID("P3", "orb_rpc_fetchMyWorkBasket"), new _RPCID("xT", "orb_rpc_fetchMyWorkBaskets"), new _RPCID("x7", "orb_rpc_fetchWorkBasketsFromQueue"), new _RPCID("x9", "orb_rpc_fetchPrivileges"), new _RPCID("kS", "orb_rpc_verifyDBConnection"), new _RPCID("rA", "orb_rpc_fetchRoleNames"), new _RPCID("zB", "orb_rpc_fetchRoles"), new _RPCID("wZ", "orb_rpc_fetchAppSpaceNames"), new _RPCID("rD", "orb_rpc_setRolePartipants"), new _RPCID("rZ", "orb_rpc_createLaunchStepElement"), new _RPCID("wA", "orb_rpc_fetchApplicationSpaces"), new _RPCID("-1", "fetchUserList"), new _RPCID("-1", "fetchSecurityDomains"), new _RPCID("-1", "isMemberOfGroup"), new _RPCID("-1", "fetchIsGroup"), new _RPCID("-1", "fetchParticipants"), new _RPCID("-1", "fetchMemberOf"), new _RPCID("-1", "getPERPCIOR")};
    private static int RPCID_TABLE_LEN = RPCID_TABLE.length;

    SyncVersion() {
    }

    private static String GetRPCID(String rpcName) throws VWException {
        rpcName = rpcName.trim();
        for (int i = 0; i < RPCID_TABLE_LEN; ++i) {
            if (!rpcName.equals(SyncVersion.RPCID_TABLE[i].name) || SyncVersion.RPCID_TABLE[i].id.equals("-1")) continue;
            return SyncVersion.RPCID_TABLE[i].id;
        }
        throw new VWException("filenet.pe.peorb.client.SyncVersion.invalidRpc", "Invalid RPC {0}", rpcName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void updateStats(String rpcName, long timingInfo) {
        rpcName = rpcName.trim();
        _RPCID aRec = null;
        for (int i = 0; i < RPCID_TABLE_LEN; ++i) {
            if (!rpcName.equals(SyncVersion.RPCID_TABLE[i].name)) continue;
            aRec = RPCID_TABLE[i];
            break;
        }
        long presentTime = new Date().getTime();
        _RPCID _RPCID2 = aRec;
        synchronized (_RPCID2) {
            aRec.nTimes++;
            if (aRec.worstTime < (double)timingInfo) {
                aRec.worstTime = timingInfo;
                aRec.whenWorstTime = presentTime;
            }
            if (aRec.bestTime > (double)timingInfo || aRec.bestTime == 0.0) {
                aRec.bestTime = timingInfo;
                aRec.whenBestTime = presentTime;
            }
            aRec.totalTime += timingInfo;
            aRec.avgTime = aRec.totalTime / (double)aRec.nTimes;
        }
    }

    protected static String[] getPERPCStats() {
        String[] res = new String[RPCID_TABLE_LEN];
        for (int i = 0; i < RPCID_TABLE_LEN; ++i) {
            res[i] = RPCID_TABLE[i].nTimes > 0L ? RPCID_TABLE[i].toString() : null;
        }
        return res;
    }

    protected static void resetPERPCStats() {
        for (int i = 0; i < RPCID_TABLE_LEN; ++i) {
            if (RPCID_TABLE[i].nTimes <= 0L) continue;
            SyncVersion.RPCID_TABLE[i].resetStats();
        }
    }

    private static byte[] generateIndata(String rpc, RPCHeader rpcHeader, IdTypeFlagsHolder typeFlags) throws VWException {
        String m_method = "generateIndata:" + rpc;
        if (typeFlags == null) {
            return null;
        }
        if (logger.isFinest()) {
            try {
                String nameFromIdentityToken = UTF8Helper.decodeString((byte[])typeFlags.name);
                logger.finest(m_className, m_method, "P8Token.name=[" + nameFromIdentityToken + "]\nRPCHeader.userName=[" + rpcHeader.userName + "]");
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        byte[] userNameArr = new byte[]{};
        try {
            userNameArr = rpcHeader.userName.getBytes("UTF-8");
        }
        catch (Exception e) {
            // empty catch block
        }
        byte[] rpcIdArr = SyncVersion.GetRPCID(rpc).getBytes();
        int length = userNameArr.length + 48 + typeFlags.token.length + rpcIdArr.length;
        byte[] inData = new byte[length];
        int inOffSet = 0;
        byte[] byteBuffer = userNameArr;
        int byteBufferLen = byteBuffer.length;
        System.arraycopy(byteBuffer, 0, inData, inOffSet, byteBufferLen);
        inOffSet += byteBufferLen;
        byteBuffer = SyncVersion.To8HexString(rpcHeader.userId).getBytes();
        byteBufferLen = byteBuffer.length;
        System.arraycopy(byteBuffer, 0, inData, inOffSet, byteBufferLen);
        inOffSet += byteBufferLen;
        byteBuffer = SyncVersion.To8HexString(rpcHeader.wsTimeStamp).getBytes();
        byteBufferLen = byteBuffer.length;
        System.arraycopy(byteBuffer, 0, inData, inOffSet, byteBufferLen);
        inOffSet += byteBufferLen;
        byteBuffer = SyncVersion.To8HexString(rpcHeader.lgTimeStamp).getBytes();
        byteBufferLen = byteBuffer.length;
        System.arraycopy(byteBuffer, 0, inData, inOffSet, byteBufferLen);
        inOffSet += byteBufferLen;
        byteBuffer = SyncVersion.To8HexString(rpcHeader.regionId).getBytes();
        byteBufferLen = byteBuffer.length;
        System.arraycopy(byteBuffer, 0, inData, inOffSet, byteBufferLen);
        inOffSet += byteBufferLen;
        byteBuffer = typeFlags.token;
        byteBufferLen = byteBuffer.length;
        System.arraycopy(byteBuffer, 0, inData, inOffSet, byteBufferLen);
        inOffSet += byteBufferLen;
        byteBuffer = rpcIdArr;
        byteBufferLen = byteBuffer.length;
        System.arraycopy(byteBuffer, 0, inData, inOffSet, byteBufferLen);
        inOffSet += byteBufferLen;
        byteBuffer = SyncVersion.To8HexString(rpcHeader.rpcTimeStamp).getBytes();
        byteBufferLen = byteBuffer.length;
        System.arraycopy(byteBuffer, 0, inData, inOffSet, byteBufferLen);
        inOffSet += byteBufferLen;
        if (rpcHeader.adj > 600 || rpcHeader.adj < -600) {
            rpcHeader.adj = 0;
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "READJUSTED! adj=" + rpcHeader.adj + ", Hex=" + SyncVersion.To8HexString(rpcHeader.adj));
            }
        }
        byteBuffer = SyncVersion.To8HexString(rpcHeader.adj).getBytes();
        byteBufferLen = byteBuffer.length;
        System.arraycopy(byteBuffer, 0, inData, inOffSet, byteBufferLen);
        inOffSet += byteBufferLen;
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, StringUtils.hexEncode(inData));
        }
        return inData;
    }

    private static byte[] generateOutdata(byte[] inData, byte[] key) throws VWException {
        String m_method = "generateOutdata";
        try {
            if (inData == null) {
                return null;
            }
            String hmacAlgorithm = "HmacSHA1";
            SecretKeySpec ks = new SecretKeySpec(key, hmacAlgorithm);
            String realAlgorithm = ks.getAlgorithm();
            Mac m = Mac.getInstance(realAlgorithm);
            m.init(ks);
            byte[] result = m.doFinal(inData);
            if (logger.isFinest()) {
                logger.finest(m_className, "generateOutdata", "Signed data=" + StringUtils.hexEncode(result));
            }
            return result;
        }
        catch (Throwable t) {
            throw new VWException(t);
        }
    }

    public static byte[] generate(String rpc, RPCHeader rpcHeader, IdTypeFlagsHolder typeFlags) throws VWException {
        return SyncVersion.generateOutdata(SyncVersion.generateIndata(rpc, rpcHeader, typeFlags), typeFlags.key);
    }

    public static String _get_FILE_DATE() {
        return "$Date:   11 Sep 2008 13:27:02  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.24  $";
    }

    private static String To8HexString(int j) {
        String s = Integer.toHexString(j = Math.abs(j)).toUpperCase();
        int n0s = 8 - s.length();
        if (n0s > 0) {
            StringBuffer buf = new StringBuffer();
            while (n0s-- > 0) {
                buf.append('0');
            }
            buf.append(s);
            s = buf.toString();
        }
        return s;
    }

    public static void main(String[] args) {
    }

    private static class _RPCID {
        String name;
        String id;
        private long nTimes = 0L;
        private double worstTime = 0.0;
        private long whenWorstTime = 0L;
        private double bestTime = 0.0;
        private long whenBestTime = 0L;
        private double avgTime = 0.0;
        private double totalTime = 0.0;
        private SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.S");
        private DecimalFormat nf = new DecimalFormat();

        private String formatDate(long t) {
            return this.df.format(new Date(t));
        }

        public _RPCID(String id, String name) {
            this.name = name;
            this.id = id;
            this.nf.setMaximumFractionDigits(2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            _RPCID _RPCID2 = this;
            synchronized (_RPCID2) {
                return this.name + SyncVersion.DELIM + this.nTimes + SyncVersion.DELIM + this.worstTime + SyncVersion.DELIM + this.formatDate(this.whenWorstTime) + SyncVersion.DELIM + this.bestTime + SyncVersion.DELIM + this.formatDate(this.whenBestTime) + SyncVersion.DELIM + this.nf.format(this.avgTime) + SyncVersion.DELIM + this.nf.format(this.totalTime / 1000.0) + "\n";
            }
        }

        private synchronized void resetStats() {
            this.nTimes = 0L;
            this.worstTime = 0.0;
            this.whenWorstTime = 0L;
            this.bestTime = 0.0;
            this.whenBestTime = 0L;
            this.avgTime = 0.0;
            this.totalTime = 0.0;
        }
    }
}

